/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: EcatMbx_Functionlist.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    Ecat Mbx
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
      5        23.03.2007  sb
        Updated source header
        Corrected Task Entry function

      1        10.08.2005  SB       1.000
        Created as consolidated version of EcatMbxRecv and EcatMbxSend

**************************************************************************************/
#ifndef __ECAT_MBX_FUNCTIONLIST_H
#define __ECAT_MBX_FUNCTIONLIST_H



/***************************************************************************************/
/* Ecat Mbx function list, prototyes */

TLR_RESULT  TaskExit_EcatMbx (void* pvRsc);

void        TaskEnter_EcatMbx(void* pvInit);



/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ECAT_MBX_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** type of <code>ECAT_MBX_STARTUPPARAMETER_Ttag</code> */
typedef struct ECAT_MBX_STARTUPPARAMETER_Ttag  ECAT_MBX_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct ECAT_MBX_STARTUPPARAMETER_Ttag    /* Task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
  TLR_BOOLEAN32 fCheckSeqNo; /* obsolete, this parameter is ignored */
};

/** @} */

/***************************************************************************************/
#endif /* #ifndef __ECAT_MBX_FUNCTIONLIST_H */
